//CTF.h - includes for POWER - Domination
//Colors - Capture The Flag mod used as base

//Power
#define MAX_CONTROL_POINTS 3
extern	cvar_t	*marker_award;
extern void SP_ControlPoint (edict_t *self);
extern void Power_Overlay(void);

#define CTF_CODE_VERSION 100

#define CTF_CAPTURE_FLASH_TIME 5
#define CTF_CRASHED_PLAYER_CHECK_DELAY 50 //10 server thinks = 1 second

#define POWER_POINTS_CONTROL_CAPTURE_BONUS 2 //returned enemy flag to own base (this is added to team capture bonus for total award)
#define POWER_POINTS_CONTROL_PROTECT_BONUS 1 //protected own flag at base

#define FLAG_RETURN_DELAY 300 //time in flag thinks (*0.1 - 300 = 30 seconds)
#define CONTROL_CAPTURE_DELAY 1 //Delay before other team can recapture (in CONTROL_THINK_TIME's)
#define CONTROL_THINK_TIME 5.0f //time between each think (in seconds)

#define FORCE_SHOW_MOTD_TIME 1.0f //time force forced showing of MOTD (in seconds)

typedef struct
{
	int teamscore[2];
	float capture_time[2];
	int CrashedPlayerCheckTime;
	char MOTD[1400];
	char WinnerMessage[1400];
	edict_t	*markers[MAX_CONTROL_POINTS];
	int	num_control_points;
	int Winner;//0 = draw, 1 - Warriors, 2 = Rogues
	int EndgameTime;//Time the level ended
} CTF_Game_Struct;

typedef enum
{
	WINNER_DRAW = 0x00,
	WINNER_WARRIORS,
	WINNER_ROGUES
} WinningTeam;

typedef struct
{
	qboolean VersionTested;//Has version checking been done?
	qboolean FirstSpawn;//First time spawning this map?
	float MOTDTime;//time showmotd entered in console (requested by Mr Damage)
	
//	int Frags;//separate frag count since resp.score is needed to display total

//Really just for player stats (in case theyre used sometime....)
//	int TotalCaptures;//How many points captured - DUH!

} CTF_Player_Struct;

typedef enum
{
	RESPAWN_NULL = 0x00,
	RESPAWN_RETURNDROPPEDOWN,
	RESPAWN_RETURNCAPTUREDENEMY,
	RESPAWN_ENEMYDROP,
	RESPAWN_MATCHSTART,
	RESPAWN_PLAYERCRASH,
	RESPAWN_OUTOFRANGE
} Respawn_Type;

typedef enum {
	CTF_GRAPPLE_STATE_FLY,
	CTF_GRAPPLE_STATE_PULL,
	CTF_GRAPPLE_STATE_HANG
} ctfgrapplestate_t;

typedef enum
{
	TEAMNAME_NULL = 0x00,
	TEAMNAME_OWNTEAM,
	TEAMNAME_OTHERTEAM
} TeamNameType;

typedef enum
{
	CLIENT_FILES_NULL = 0x00,
	NO_CLIENT_FILES,
	OLD_CLIENT_FILES
} CheckKick;

#define CTF_GRAPPLE_SPEED					650 // speed of grapple in flight
#define CTF_GRAPPLE_PULL_SPEED				650	// speed player is pulled at

extern cvar_t *prop_enable;
extern cvar_t *hook_enable;
extern cvar_t *hook_distance;
extern cvar_t *curse_enable;
extern cvar_t *maxcaptures;
extern cvar_t *keep_admin_status;
extern CTF_Game_Struct CTFGame;
extern char CTF_Version[];
extern qboolean ServerNeedsReset;

//CTF
extern edict_t *SelectRandomDeathmatchSpawnPoint (edict_t *ent);
extern float PlayersRangeFromSpot (edict_t *spot);
extern void InitialiseCTF(void);
extern void CheckAwardDefendBonus(edict_t *target, edict_t *attacker);
extern CTF_Game_Struct CTFGame;
extern void CTFMapRotateEvent(void);
extern void PrecacheCTFItems(gclient_t *client);
extern void VersionCheck(edict_t *ent);
extern void VersionCheckFail(edict_t *ent, CheckKick Reason);

//INTERFACE
extern void ForceShowMOTD(edict_t *ent);

//P_CLIENT
extern void ClientUserinfoChanged (edict_t *ent, char *userinfo);
extern void nameclash_think(edict_t *self);
extern void maxrate_think(edict_t *self);

// GRAPPLE
extern void CTFWeapon_Grapple (edict_t *ent);
extern void CTFPlayerResetGrapple(edict_t *ent);
extern void CTFGrapplePull(edict_t *self);
extern void CTFResetGrapple(edict_t *self, qboolean PlaySound);
extern void CTFMapEndEvent(void);
extern void P_ProjectSource (gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result);
extern qboolean CheckTeamDamage (edict_t *targ, edict_t *attacker);
extern void Weapon_Generic (edict_t *ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int *pause_frames, int *fire_frames, void (*fire)(edict_t *ent));

//DEBUG
extern qboolean CTFPickup_Flag(edict_t *ent, edict_t *other);

//MOTD
extern void LoadMOTD(void);
extern void DisplayCTFMOTD(edict_t *ent);

//GAME END
extern int CheckCTFMatchFragRules(void);
extern int CheckCTFRules(void);
extern void DetermineWinner(void);
extern void DisplayEndgameMessage(edict_t* ent);

